/*
 * Decompiled with CFR 0.152.
 */
package com.ordana.immersive_weathering.data.block_growths;

import com.google.common.base.Suppliers;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import com.ordana.immersive_weathering.ImmersiveWeathering;
import com.ordana.immersive_weathering.configs.CommonConfigs;
import com.ordana.immersive_weathering.data.block_growths.IConditionalGrowingBlock;
import com.ordana.immersive_weathering.data.block_growths.TickSource;
import com.ordana.immersive_weathering.data.block_growths.growths.ConfigurableBlockGrowth;
import com.ordana.immersive_weathering.data.block_growths.growths.IBlockGrowth;
import com.ordana.immersive_weathering.data.block_growths.growths.builtin.BuiltinBlockGrowth;
import com.ordana.immersive_weathering.data.block_growths.growths.builtin.NoOpBlockGrowth;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.io.FileWriter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.TreeMap;
import java.util.function.Supplier;
import net.minecraft.class_1923;
import net.minecraft.class_1959;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2680;
import net.minecraft.class_2818;
import net.minecraft.class_2902;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3300;
import net.minecraft.class_3695;
import net.minecraft.class_4309;
import net.minecraft.class_5455;
import net.minecraft.class_6880;
import net.minecraft.class_6903;

public class BlockGrowthHandler
extends class_4309 {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().create();
    public static final BlockGrowthHandler RELOAD_INSTANCE = new BlockGrowthHandler();
    private static final Map<class_2960, JsonElement> GROWTH_TO_PARSE = new HashMap<class_2960, JsonElement>();
    private static final Map<TickSource, Map<class_2248, Set<IBlockGrowth>>> GROWTH_FOR_BLOCK = new EnumMap<TickSource, Map<class_2248, Set<IBlockGrowth>>>(TickSource.class);
    private static final Map<TickSource, Set<IBlockGrowth>> UNIVERSAL_GROWTHS = new EnumMap<TickSource, Set<IBlockGrowth>>(TickSource.class);
    private boolean needsRefresh;

    public BlockGrowthHandler() {
        super(GSON, "block_growths");
    }

    public static Optional<Set<IBlockGrowth>> getBlockGrowth(TickSource source, class_2248 block) {
        return Optional.ofNullable(GROWTH_FOR_BLOCK.get((Object)source)).map(m -> (Set)m.get(block));
    }

    public static void tickBlock(TickSource source, class_2680 state, class_3218 level, class_2338 pos) {
        Optional<Set<IBlockGrowth>> growth;
        IConditionalGrowingBlock cb;
        if (!CommonConfigs.BLOCK_GROWTHS.get().booleanValue()) {
            return;
        }
        class_2248 class_22482 = state.method_26204();
        if (class_22482 instanceof IConditionalGrowingBlock && !(cb = (IConditionalGrowingBlock)class_22482).canGrow(state)) {
            return;
        }
        com.google.common.base.Supplier biome = Suppliers.memoize(() -> level.method_23753(pos));
        Set<IBlockGrowth> universalGroup = UNIVERSAL_GROWTHS.get((Object)source);
        if (universalGroup != null) {
            for (IBlockGrowth config : universalGroup) {
                config.tryGrowing(pos, state, level, (Supplier<class_6880<class_1959>>)biome);
            }
        }
        if ((growth = BlockGrowthHandler.getBlockGrowth(source, state.method_26204())).isPresent()) {
            for (IBlockGrowth config : growth.get()) {
                config.tryGrowing(pos, state, level, (Supplier<class_6880<class_1959>>)biome);
            }
        }
    }

    public static void performSkyAccessTick(class_3218 level, class_2818 levelChunk, int randomTickSpeed) {
        class_1923 chunkpos = levelChunk.method_12004();
        float chance = (float)randomTickSpeed / 48.0f;
        int minX = chunkpos.method_8326();
        int minZ = chunkpos.method_8328();
        boolean isRaining = level.method_8419();
        do {
            if (!(chance > level.method_8409().method_43057())) continue;
            class_2338 firstAirPos = level.method_8598(class_2902.class_2903.field_13197, level.method_8536(minX, 0, minZ, 15));
            class_2338 targetPos = firstAirPos.method_10074();
            class_2680 state = level.method_8320(targetPos);
            TickSource source = TickSource.CLEAR_SKY;
            if (isRaining) {
                class_1959 biome = (class_1959)level.method_23753(targetPos).comp_349();
                class_1959.class_1963 precipitation = biome.method_8694();
                if (precipitation == class_1959.class_1963.field_9382 && biome.method_33599(targetPos)) {
                    precipitation = class_1959.class_1963.field_9383;
                }
                source = precipitation == class_1959.class_1963.field_9383 ? TickSource.SNOW : TickSource.RAIN;
            }
            BlockGrowthHandler.tickBlock(source, state, level, targetPos);
        } while ((chance -= 1.0f) > 0.0f);
    }

    protected void apply(Map<class_2960, JsonElement> jsons, class_3300 manager, class_3695 profile) {
        this.needsRefresh = true;
        GROWTH_TO_PARSE.clear();
        for (Map.Entry<class_2960, JsonElement> e : jsons.entrySet()) {
            GROWTH_TO_PARSE.put(e.getKey(), e.getValue().deepCopy());
        }
    }

    public void rebuild(class_5455 registryAccess) {
        if (this.needsRefresh) {
            this.needsRefresh = false;
            ArrayList<IBlockGrowth> growths = new ArrayList<IBlockGrowth>();
            for (Map.Entry<class_2960, JsonElement> e2 : GROWTH_TO_PARSE.entrySet()) {
                IBlockGrowth g;
                JsonObject jo;
                String name = e2.getKey().method_12832();
                if (CommonConfigs.DISABLED_GROWTHS.get().contains(name.toLowerCase(Locale.ROOT))) continue;
                JsonElement json = e2.getValue();
                DataResult result = json instanceof JsonObject && (jo = (JsonObject)json).has("builtin") ? BuiltinBlockGrowth.CODEC.parse((DynamicOps)class_6903.method_40414((DynamicOps)JsonOps.INSTANCE, (class_5455)registryAccess), (Object)json) : ConfigurableBlockGrowth.CODEC.parse((DynamicOps)class_6903.method_40414((DynamicOps)JsonOps.INSTANCE, (class_5455)registryAccess), (Object)json);
                Optional o = result.resultOrPartial(error -> ImmersiveWeathering.LOGGER.error("Failed to read block growth JSON object for {} : {}", e2.getKey(), error));
                if (o.isPresent() && !((g = (IBlockGrowth)o.get()) instanceof NoOpBlockGrowth)) {
                    growths.add(g);
                }
                o.ifPresent(growths::add);
            }
            ImmersiveWeathering.LOGGER.info("Loaded {} block growths configurations", (Object)GROWTH_TO_PARSE.size());
            GROWTH_FOR_BLOCK.clear();
            UNIVERSAL_GROWTHS.clear();
            for (IBlockGrowth config : growths) {
                Collection<TickSource> sources = config.getTickSources();
                for (TickSource s : sources) {
                    Object group;
                    Iterable<? extends class_2248> owners = config.getOwners();
                    if (owners == null) {
                        group = UNIVERSAL_GROWTHS.computeIfAbsent(s, e -> new HashSet());
                        group.add(config);
                        continue;
                    }
                    group = GROWTH_FOR_BLOCK.computeIfAbsent(s, e -> new Object2ObjectOpenHashMap());
                    config.getOwners().forEach(arg_0 -> BlockGrowthHandler.lambda$rebuild$6((Map)group, config, arg_0));
                }
            }
            GROWTH_TO_PARSE.clear();
        }
    }

    private void writeToFile(ConfigurableBlockGrowth obj, FileWriter writer) {
        DataResult r = ConfigurableBlockGrowth.CODEC.encodeStart((DynamicOps)JsonOps.INSTANCE, (Object)obj);
        r.result().ifPresent(a -> GSON.toJson((JsonElement)this.sortJson(a.getAsJsonObject()), (Appendable)writer));
    }

    private JsonObject sortJson(JsonObject jsonObject) {
        try {
            TreeMap<String, JsonElement> joToMap = new TreeMap<String, JsonElement>();
            jsonObject.entrySet().forEach(e -> {
                JsonElement j = (JsonElement)e.getValue();
                if (j instanceof JsonObject) {
                    JsonObject jo = (JsonObject)j;
                    j = this.sortJson(jo);
                }
                joToMap.put((String)e.getKey(), j);
            });
            JsonObject sortedJSON = new JsonObject();
            joToMap.forEach((arg_0, arg_1) -> ((JsonObject)sortedJSON).add(arg_0, arg_1));
            return sortedJSON;
        }
        catch (Exception exception) {
            return jsonObject;
        }
    }

    private static /* synthetic */ void lambda$rebuild$6(Map group, IBlockGrowth config, class_2248 b) {
        group.computeIfAbsent(b, k -> new HashSet()).add(config);
    }
}

